/**
* \file: mlink_wl_if_internals.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* MLINK WL Adapter
*
* \component: mlink
*
* \author: Michael Methner ADITG/SW1 mmethner@de.adit-jv.com
*
* \copyright: (c) 2003 - 2013 ADIT Corporation
*
* \history
* 0.1 Michael Methner Initial version
*
***********************************************************************/

#ifndef _MLINK_WL_INTERNALS_H_
#define _MLINK_WL_INTERNALS_H_

#include <compositor-shim.h>


struct mlink_wl_context
{
    int intialized;

    mlink_wl_error_callback * pErrorCb;

    enum mlink_wl_flags flags;
    int support_touch;
    int last_pointer_x;
    int last_pointer_y;


    VNCViewerSDK * pViewerSdk;
    VNCViewer *pViewer;

    int screen_x_offset;
    int screen_y_offset;
    int screen_width;
    int screen_height;
    unsigned int force_fullscreen;

    unsigned int layer_id;
    unsigned int surface_id;

    int width;
    int height;
    int stride;
    int bpp;

    VNCPointerDeviceButton pointer_button_state;
    vnc_uint16_t pointer_x;
    vnc_uint16_t pointer_y;

    int touch_valid[MLINK_WL_MAX_TOUCHPOINTS];
    VNCTouchDescriptor touch_desc[MLINK_WL_MAX_TOUCHPOINTS];

    unsigned char * p_image[4];

    /* apx internals */
    mlink_wl_if_context * p_wl_if_context;
    int surface_format;

    /* wayland internals */
    struct wl_list seats;
    struct wl_display* p_wl_display;
    struct wl_surface* p_wl_surface;
    struct wl_compositor* p_wl_compositor;
    struct serverinfo* p_wl_ext_serverinfo;
    unsigned int wl_connect_id;
    struct wl_registry* p_wl_registry;
    struct wl_event_queue *p_wl_input_queue;
    pthread_mutex_t lock_seat;

    /* DLT */
    DltContext * p_dlt_ctx;

    /* compositor-shim */
    struct compositor_shim_context* wlAdapterContext;
    struct compositor_shim_surface_context wlAdapterSurfaceContext;

    /* H.264 */
    int is_h264_enabled;
};

struct WlSeat
{
    char*                      p_seat_name;
    uint32_t                   seat_id;
    struct wl_seat*            p_wl_seat;
    struct wl_touch*           p_wl_touch;
    struct wl_pointer*         p_wl_pointer;
    struct mlink_wl_context*   p_wl_context;
    struct wl_list             link;
};

int
mlink_wl_is_equal_vnc_pixelformat(VNCPixelFormat * p_1, VNCPixelFormat * p_2);

void
mlink_free_mem(void** input_ptr);

void
mlink_wl_pump_events(mlink_wl_context * p_wl_ctx);

#endif
